<?php
/*
 * Created by 2C2P
 * Date 28 June 2017
 * Update request_timestamp column in database when plugin/module is installed in Magento-2
 */

namespace P2c2p\P2c2pPayment\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.4.2', '<')) {
            $connection = $setup->getConnection();
            $tableName = $setup->getTable('p2c2p_meta'); 

            $connection->changeColumn(
                $tableName,
                'request_timestamp',
                'request_timestamp',
                [
                    'type' => Table::TYPE_TIMESTAMP,
                    'nullable' => true,  // Making the column nullable
                    'default' => Table::TIMESTAMP_INIT
                ]
            );
        }
        $setup->endSetup();
    }
}
