<?php


namespace P2c2p\P2c2pPayment\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Escaper;
use Magento\Framework\View\Asset\Repository as AssetRepository;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Store\Model\StoreManagerInterface;


class PaymentConfigProvider implements ConfigProviderInterface
{
    const PAYMENT_CODE = 'p2c2p';
    const  XML_PATH_P2C2PPAYMENT_ACTIVE = 'payment/p2c2ppayment/active';
    const  XML_PATH_P2C2PPAYMENT_TITLE = 'payment/p2c2ppayment/title';
    const  XML_PATH_P2C2PPAYMENT_LOGO = 'payment/p2c2ppayment/p2c2p_logo';
    /**
     * @var Escaper
     */
    private $escaper;
    /**
     * @var AssetRepository
     */
    private $assetRepository;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var PaymentHelper
     */
    private $paymentHelper;
    /**
     * @var CheckoutSession
     */
    private $checkoutSession;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;


    public function __construct(
        PaymentHelper         $paymentHelper,
        CheckoutSession       $checkoutSession,
        AssetRepository       $assetRepository,
        ScopeConfigInterface  $scopeConfig,
        Escaper               $escaper,
        StoreManagerInterface $storeManager
    )
    {
        $this->paymentHelper = $paymentHelper;
        $this->checkoutSession = $checkoutSession;
        $this->escaper = $escaper;
        $this->assetRepository = $assetRepository;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
    }


    /**
     * Config Data for checkout
     *
     * @return array
     */
    public function getConfig()
    {
        $config = [];
        $active = $this->getStoreConfig(self::XML_PATH_P2C2PPAYMENT_ACTIVE);
        if ($active) {
            $config['payment'][self::PAYMENT_CODE]['isActive'] = true;
            $config['payment'][self::PAYMENT_CODE]['title'] = $this->getStoreConfig(self::XML_PATH_P2C2PPAYMENT_TITLE);
            // $config['payment'][self::PAYMENT_CODE]['logo'] = $this->getMediaPath() . '/p2c2p/' . $this->getStoreConfig(self::XML_PATH_P2C2PPAYMENT_LOGO);

            // Get logo from config, or use default logo
            $logoConfig = $this->getStoreConfig(self::XML_PATH_P2C2PPAYMENT_LOGO);
            if (!empty($logoConfig)) {
                $config['payment'][self::PAYMENT_CODE]['logo'] = $this->getMediaPath() . '/p2c2p/' . $logoConfig;
            } else {
                // Use default logo from module assets
                try {
                    $config['payment'][self::PAYMENT_CODE]['logo'] = $this->assetRepository->getUrl(
                        'P2c2p_P2c2pPayment::images/2c2p-logo.png',
                        ['_secure' => true]
                    );
                } catch (\Exception $e) {
                    // Fallback to empty string if default logo doesn't exist
                    $config['payment'][self::PAYMENT_CODE]['logo'] = '';
                }
            }
        } else {
            $config['payment'][self::PAYMENT_CODE]['isActive'] = false;
        }

        return $config;
    }

    public function getStoreConfig($path, $scopeCode = null)
    {
        return $this->scopeConfig->getValue(
            $path, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $scopeCode
        );
    }

    public function getMediaPath()
    {
        return $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
    }
}
