<?php

namespace P2c2p\P2c2pPayment\Model\Config\Backend;

use Magento\Framework\Filesystem;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\ObjectManager;

class FilePathHelper
{
    protected $filesystem;

    public function __construct(
        Filesystem $filesystem
    ) {
        $this->filesystem = $filesystem;
    }

    public function getFullPath($relativePath)
    {
        $varDirectory = $this->filesystem->getDirectoryRead(DirectoryList::VAR_DIR);
        
        // Prepend upload base directory
        $relativePath = ltrim($relativePath, '/');
        $fullPath = $varDirectory->getAbsolutePath('2c2p/' . $relativePath);
        
        // Add logging
        $logger = ObjectManager::getInstance()->get(\Psr\Log\LoggerInterface::class);
        $logger->debug('FilePathHelper - relativePath: ' . $relativePath);
        $logger->debug('FilePathHelper - fullPath: ' . $fullPath);
        $logger->debug('FilePathHelper - file exists: ' . ($varDirectory->isFile('2c2p/' . $relativePath) ? 'YES' : 'NO'));

        if (!$varDirectory->isFile('2c2p/' . $relativePath)) {
            $logger->error('FilePathHelper - File not found: 2c2p/' . $relativePath);
            throw new \Magento\Framework\Exception\LocalizedException(
                __('File not found: %1', $relativePath)
            );
        } 

        return $fullPath;
    }
}