<?php
namespace P2c2p\P2c2pPayment\Model\Config\Backend;

use Magento\Config\Model\Config\Backend\File as BackendFile;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Filesystem\Io\File as IoFile;

class File extends BackendFile
{
    protected $_allowedExtensions = ['pem', 'crt', 'cer', 'pfx'];
    
    // Define upload base path (Magento appends scope info)
    protected $_uploadDir = '2c2p';

    // Keep scope info in upload path for multi-store support
    protected function _addWhetherScopeInfo()
    {
        return false;
    }

    public function beforeSave()
    {
        $value = $this->getValue();
        $fieldId = $this->getFieldConfig()['id'];
        $section = 'p2c2ppayment';
        $group = 'p2c2ppayment';

        try {
            $logger = ObjectManager::getInstance()->get(\Psr\Log\LoggerInterface::class);
            $logger->info('<pre>Upload Path: ' . print_r($_FILES, 1) . '</pre>');
            // $logger->info('$_FILES dump: ' . print_r($_FILES, true));
            $fileData = $this->extractUploadedFile($section, $fieldId);
            if (!$fileData) {
                throw new LocalizedException(__('No valid file uploaded for ' . $fieldId));
            }

            $logger->info('<pre>fieldId: ' . print_r($fieldId, 1) . '</pre>');
            $logger->info('<pre>fileData: ' . print_r($fileData, 1) . '</pre>');

            // $uploader = $this->_uploaderFactory->create(['fileId' => $fileData]);
            $uploader = $this->_uploaderFactory->create();
            $uploader->setFiles([$fileData]);
            $uploader->setAllowedExtensions($this->_allowedExtensions);
            $uploader->setAllowRenameFiles(true);
            $uploader->setFilesDispersion(false);
            $uploader->setAllowCreateFolders(true); 

            $uploadPath = $this->_getUploadDir(); // Includes scope info
            $logger->info('Upload Path: ' . $uploadPath);

            $ioFile = ObjectManager::getInstance()->get(IoFile::class);
            if (!$ioFile->fileExists($uploadPath, false)) {
                $logger->info('Creating directory: ' . $uploadPath);
                $ioFile->mkdir($uploadPath, 0755, true);
            }

            $result = $uploader->save($uploadPath);
            $logger->info('Upload Result: ' . print_r($result, true));

            if ($result && isset($result['file'])) {
                $finalFile = $uploadPath . '/' . $result['file'];

                if ($ioFile->fileExists($finalFile)) {
                    $ioFile->chmod($finalFile, 0640);
                }

                // Store relative path, Magento uses getUploadDir for this
                // $this->setValue($this->_prependScopeInfo($this->_uploadDir) . '/' . $result['file']);
                // $this->setValue($this->_prependScopeInfo($result['file']));
                $this->setValue($this->getScope() . '/' . $this->getScopeId() . '/' . $result['file']);
            }

        } catch (\Exception $e) {
            $logger->error('Upload error: ' . $e->getMessage());

            if (is_array($value) && !empty($value['delete'])) {
                $this->setValue('');
            } else {
                $this->setValue($value['value'] ?? '');
            }
        }

        return parent::beforeSave();
    }

    protected function _getUploadDir()
    {
        $baseUploadDir = $this->_filesystem
            ->getDirectoryWrite(\Magento\Framework\App\Filesystem\DirectoryList::VAR_DIR)
            ->getAbsolutePath();

        $path = $baseUploadDir . $this->_uploadDir;

        // Add scope info (e.g., default/0/, websites/1/, stores/2/)
        if ($this->_addWhetherScopeInfo()) {
            $path .= '/' . $this->getScope() . '/' . $this->getScopeId();
        }

        return $path;
    }

    protected function getTmpUploadDir()
    {
        return $this->_uploadDir;
    }

    private function extractUploadedFile($section, $fieldId)
    {
        if (!isset($_FILES['groups']['tmp_name'][$section]['fields'][$fieldId]['value'])) {
            return null;
        }

        $file = [];
        $paths = ['name', 'type', 'tmp_name', 'error', 'size'];

        foreach ($paths as $path) {
            $file[$path] = $_FILES['groups'][$path][$section]['fields'][$fieldId]['value'] ?? null;
        }

        $logger = ObjectManager::getInstance()->get(\Psr\Log\LoggerInterface::class);
        $logger->info('Extracted file data: ' . print_r($file, true));
        if (empty($file['tmp_name']) || !is_uploaded_file($file['tmp_name'])) {
            return null;
        }

        return $file;
    }

}
