<?php

namespace P2c2p\P2c2pPayment\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Store\Model\ScopeInterface;

class P2c2pService extends AbstractHelper
{
  private $objConfigSettings;
  private $curl;
  private $url;

  function __construct(
    ScopeConfigInterface $configSettings,
    Curl $curl
  ) {
    $this->objConfigSettings = $configSettings->getValue(
        "payment/p2c2ppayment",
        ScopeInterface::SCOPE_STORE
    );
    $this->curl = $curl;
    $this->url = $this->objConfigSettings["mode"]
      ? "https://sandbox-pgw.2c2p.com/payment/4.3"
      : "https://pgw.2c2p.com/payment/4.3"; 
  }

  public function paymentToken($token)
  {
    $url = $this->url . "/paymentToken";
    $payload = json_encode([ "payload" => $token ]);

    // request
    $this->curl->addHeader('Content-Type', 'application/json');
    $this->curl->post($url, $payload);

    return [
      "status" => $this->curl->getStatus(),
      "data" => json_decode($this->curl->getBody(), true)
    ];
  }
}