<?php

/*
 * Created by 2C2P
 * Date 19 June 2017
 * P2c2pCurrencyCode helper class is give the 2C2P payment gateway suppored currency code.
 */

namespace P2c2p\P2c2pPayment\Helper;
use Magento\Framework\App\Helper\AbstractHelper;

class P2c2pCurrencyCode extends AbstractHelper
{
    // This function is used to get the currency code with currency number and exponent.
    public function getP2c2pSupportedCurrenyCode()
    {
        return [
            "CLF" => ["Num" => "990", "Exponent" => "4"],
            "BHD" => ["Num" => "048", "Exponent" => "3"],
            "IQD" => ["Num" => "368", "Exponent" => "3"],
            "JOD" => ["Num" => "400", "Exponent" => "3"],
            "KWD" => ["Num" => "414", "Exponent" => "3"],
            "LYD" => ["Num" => "434", "Exponent" => "3"],
            "OMR" => ["Num" => "512", "Exponent" => "3"],
            "TND" => ["Num" => "788", "Exponent" => "3"],
            "AED" => ["Num" => "784", "Exponent" => "2"],
            "AFN" => ["Num" => "971", "Exponent" => "2"],
            "ALL" => ["Num" => "008", "Exponent" => "2"],
            "AMD" => ["Num" => "051", "Exponent" => "2"],
            "ANG" => ["Num" => "532", "Exponent" => "2"],
            "AOA" => ["Num" => "973", "Exponent" => "2"],
            "ARS" => ["Num" => "032", "Exponent" => "2"],
            "AUD" => ["Num" => "036", "Exponent" => "2"],
            "AWG" => ["Num" => "533", "Exponent" => "2"],
            "AZN" => ["Num" => "944", "Exponent" => "2"],
            "BAM" => ["Num" => "977", "Exponent" => "2"],
            "BBD" => ["Num" => "052", "Exponent" => "2"],
            "BDT" => ["Num" => "050", "Exponent" => "2"],
            "BGN" => ["Num" => "975", "Exponent" => "2"],
            "BMD" => ["Num" => "060", "Exponent" => "2"],
            "BND" => ["Num" => "096", "Exponent" => "2"],
            "BOB" => ["Num" => "068", "Exponent" => "2"],
            "BOV" => ["Num" => "984", "Exponent" => "2"],
            "BRL" => ["Num" => "986", "Exponent" => "2"],
            "BSD" => ["Num" => "044", "Exponent" => "2"],
            "BTN" => ["Num" => "064", "Exponent" => "2"],
            "BWP" => ["Num" => "072", "Exponent" => "2"],
            "BYN" => ["Num" => "933", "Exponent" => "2"],
            "BZD" => ["Num" => "084", "Exponent" => "2"],
            "CAD" => ["Num" => "124", "Exponent" => "2"],
            "CDF" => ["Num" => "976", "Exponent" => "2"],
            "CHE" => ["Num" => "947", "Exponent" => "2"],
            "CHF" => ["Num" => "756", "Exponent" => "2"],
            "CHW" => ["Num" => "948", "Exponent" => "2"],
            "CNY" => ["Num" => "156", "Exponent" => "2"],
            "COP" => ["Num" => "170", "Exponent" => "2"],
            "COU" => ["Num" => "970", "Exponent" => "2"],
            "CRC" => ["Num" => "188", "Exponent" => "2"],
            "CUC" => ["Num" => "931", "Exponent" => "2"],
            "CUP" => ["Num" => "192", "Exponent" => "2"],
            "CZK" => ["Num" => "203", "Exponent" => "2"],
            "DKK" => ["Num" => "208", "Exponent" => "2"],
            "DOP" => ["Num" => "214", "Exponent" => "2"],
            "DZD" => ["Num" => "012", "Exponent" => "2"],
            "EGP" => ["Num" => "818", "Exponent" => "2"],
            "ERN" => ["Num" => "232", "Exponent" => "2"],
            "ETB" => ["Num" => "230", "Exponent" => "2"],
            "EUR" => ["Num" => "978", "Exponent" => "2"],
            "FJD" => ["Num" => "242", "Exponent" => "2"],
            "FKP" => ["Num" => "238", "Exponent" => "2"],
            "GBP" => ["Num" => "826", "Exponent" => "2"],
            "GEL" => ["Num" => "981", "Exponent" => "2"],
            "GHS" => ["Num" => "936", "Exponent" => "2"],
            "GIP" => ["Num" => "292", "Exponent" => "2"],
            "GMD" => ["Num" => "270", "Exponent" => "2"],
            "GTQ" => ["Num" => "320", "Exponent" => "2"],
            "GYD" => ["Num" => "328", "Exponent" => "2"],
            "HKD" => ["Num" => "344", "Exponent" => "2"],
            "HNL" => ["Num" => "340", "Exponent" => "2"],
            "HRK" => ["Num" => "191", "Exponent" => "2"],
            "HTG" => ["Num" => "332", "Exponent" => "2"],
            "HUF" => ["Num" => "348", "Exponent" => "2"],
            "IDR" => ["Num" => "360", "Exponent" => "2"],
            "ILS" => ["Num" => "376", "Exponent" => "2"],
            "INR" => ["Num" => "356", "Exponent" => "2"],
            "IRR" => ["Num" => "364", "Exponent" => "2"],
            "JMD" => ["Num" => "388", "Exponent" => "2"],
            "KES" => ["Num" => "404", "Exponent" => "2"],
            "KGS" => ["Num" => "417", "Exponent" => "2"],
            "KHR" => ["Num" => "116", "Exponent" => "2"],
            "KPW" => ["Num" => "408", "Exponent" => "2"],
            "KYD" => ["Num" => "136", "Exponent" => "2"],
            "KZT" => ["Num" => "398", "Exponent" => "2"],
            "LAK" => ["Num" => "418", "Exponent" => "2"],
            "LBP" => ["Num" => "422", "Exponent" => "2"],
            "LKR" => ["Num" => "144", "Exponent" => "2"],
            "LRD" => ["Num" => "430", "Exponent" => "2"],
            "LSL" => ["Num" => "426", "Exponent" => "2"],
            "MAD" => ["Num" => "504", "Exponent" => "2"],
            "MDL" => ["Num" => "498", "Exponent" => "2"],
            "MKD" => ["Num" => "807", "Exponent" => "2"],
            "MMK" => ["Num" => "104", "Exponent" => "2"],
            "MNT" => ["Num" => "496", "Exponent" => "2"],
            "MOP" => ["Num" => "446", "Exponent" => "2"],
            "MUR" => ["Num" => "480", "Exponent" => "2"],
            "MVR" => ["Num" => "462", "Exponent" => "2"],
            "MWK" => ["Num" => "454", "Exponent" => "2"],
            "MXN" => ["Num" => "484", "Exponent" => "2"],
            "MXV" => ["Num" => "979", "Exponent" => "2"],
            "MYR" => ["Num" => "458", "Exponent" => "2"],
            "MZN" => ["Num" => "943", "Exponent" => "2"],
            "NAD" => ["Num" => "516", "Exponent" => "2"],
            "NGN" => ["Num" => "566", "Exponent" => "2"],
            "NIO" => ["Num" => "558", "Exponent" => "2"],
            "NOK" => ["Num" => "578", "Exponent" => "2"],
            "NPR" => ["Num" => "524", "Exponent" => "2"],
            "NZD" => ["Num" => "554", "Exponent" => "2"],
            "PAB" => ["Num" => "590", "Exponent" => "2"],
            "PEN" => ["Num" => "604", "Exponent" => "2"],
            "PGK" => ["Num" => "598", "Exponent" => "2"],
            "PHP" => ["Num" => "608", "Exponent" => "2"],
            "PKR" => ["Num" => "586", "Exponent" => "2"],
            "PLN" => ["Num" => "985", "Exponent" => "2"],
            "QAR" => ["Num" => "634", "Exponent" => "2"],
            "RON" => ["Num" => "946", "Exponent" => "2"],
            "RSD" => ["Num" => "941", "Exponent" => "2"],
            "RUB" => ["Num" => "643", "Exponent" => "2"],
            "SAR" => ["Num" => "682", "Exponent" => "2"],
            "SBD" => ["Num" => "090", "Exponent" => "2"],
            "SCR" => ["Num" => "690", "Exponent" => "2"],
            "SDG" => ["Num" => "938", "Exponent" => "2"],
            "SEK" => ["Num" => "752", "Exponent" => "2"],
            "SGD" => ["Num" => "702", "Exponent" => "2"],
            "SHP" => ["Num" => "654", "Exponent" => "2"],
            "SLL" => ["Num" => "694", "Exponent" => "2"],
            "SOS" => ["Num" => "706", "Exponent" => "2"],
            "SRD" => ["Num" => "968", "Exponent" => "2"],
            "SSP" => ["Num" => "728", "Exponent" => "2"],
            "STD" => ["Num" => "678", "Exponent" => "2"],
            "SVC" => ["Num" => "222", "Exponent" => "2"],
            "SYP" => ["Num" => "760", "Exponent" => "2"],
            "SZL" => ["Num" => "748", "Exponent" => "2"],
            "THB" => ["Num" => "764", "Exponent" => "2"],
            "TJS" => ["Num" => "972", "Exponent" => "2"],
            "TMT" => ["Num" => "934", "Exponent" => "2"],
            "TOP" => ["Num" => "776", "Exponent" => "2"],
            "TRY" => ["Num" => "949", "Exponent" => "2"],
            "TTD" => ["Num" => "780", "Exponent" => "2"],
            "TWD" => ["Num" => "901", "Exponent" => "2"],
            "TZS" => ["Num" => "834", "Exponent" => "2"],
            "UAH" => ["Num" => "980", "Exponent" => "2"],
            "USD" => ["Num" => "840", "Exponent" => "2"],
            "USN" => ["Num" => "997", "Exponent" => "2"],
            "UYU" => ["Num" => "858", "Exponent" => "2"],
            "UZS" => ["Num" => "860", "Exponent" => "2"],
            "VEF" => ["Num" => "937", "Exponent" => "2"],
            "WST" => ["Num" => "882", "Exponent" => "2"],
            "XCD" => ["Num" => "951", "Exponent" => "2"],
            "YER" => ["Num" => "886", "Exponent" => "2"],
            "ZAR" => ["Num" => "710", "Exponent" => "2"],
            "ZMW" => ["Num" => "967", "Exponent" => "2"],
            "ZWL" => ["Num" => "932", "Exponent" => "2"],
            "MGA" => ["Num" => "969", "Exponent" => "1"],
            "MRO" => ["Num" => "478", "Exponent" => "1"],
            "BIF" => ["Num" => "108", "Exponent" => "0"],
            "BYR" => ["Num" => "974", "Exponent" => "0"],
            "CLP" => ["Num" => "152", "Exponent" => "0"],
            "CVE" => ["Num" => "132", "Exponent" => "0"],
            "DJF" => ["Num" => "262", "Exponent" => "0"],
            "GNF" => ["Num" => "324", "Exponent" => "0"],
            "ISK" => ["Num" => "352", "Exponent" => "0"],
            "JPY" => ["Num" => "392", "Exponent" => "0"],
            "KMF" => ["Num" => "174", "Exponent" => "0"],
            "KRW" => ["Num" => "410", "Exponent" => "0"],
            "PYG" => ["Num" => "600", "Exponent" => "0"],
            "RWF" => ["Num" => "646", "Exponent" => "0"],
            "UGX" => ["Num" => "800", "Exponent" => "0"],
            "UYI" => ["Num" => "940", "Exponent" => "0"],
            "VND" => ["Num" => "704", "Exponent" => "0"],
            "VUV" => ["Num" => "548", "Exponent" => "0"],
            "XAF" => ["Num" => "950", "Exponent" => "0"],
            "XOF" => ["Num" => "952", "Exponent" => "0"],
            "XPF" => ["Num" => "953", "Exponent" => "0"],
        ];
    }

    // This function is used to get the Exponents values and it is used to calculate with selected currency code.
    public function getP2c2pSupportedCurrencyExponents()
    {
        return [
            "1" => "10",
            "2" => "100",
            "3" => "1000",
            "4" => "10000",
            "5" => "100000",
        ];
    }
}
