<?php

namespace P2c2p\P2c2pPayment\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use Magento\Framework\Stdlib\DateTime\DateTime;


class JWT
{
  protected $encryptor;
    protected $dateTime;

    public function __construct(
        Context $context,
        EncryptorInterface $encryptor,
        DateTime $dateTime
    ) {
        $this->encryptor = $encryptor;
        $this->dateTime = $dateTime;
    }

    public function base64UrlEncode($data)
    {
        return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($data));
    }

    public function base64UrlDecode($data)
    {
        return base64_decode(str_replace(['-', '_'], ['+', '/'], $data));
    }

    public function decodeBase64Json($token)
    {
        $decoded = $this->base64UrlDecode($token);
        $json = json_decode($decoded, true);
        return $json;
    }

    public function createJwt($secretKey, $payload)
    {
        $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);
        $payload = json_encode($payload);

        $base64UrlHeader = $this->base64UrlEncode($header);
        $base64UrlPayload = $this->base64UrlEncode($payload);

        $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $secretKey, true);
        $base64UrlSignature = $this->base64UrlEncode($signature);

        $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

        return $jwt;
    }

    public function decodeJwt($secretKey, $jwt)
    {
        // split the string on three dots
        list($base64UrlHeader, $base64UrlPayload, $base64UrlSignature) = explode('.', $jwt);

        // decode the parts
        $header = json_decode($this->base64UrlDecode($base64UrlHeader), true);
        $payload = json_decode($this->base64UrlDecode($base64UrlPayload), true);
        $signatureProvided = $this->base64UrlDecode($base64UrlSignature);

        // verify the signature
        $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $secretKey, true);

        if ($signatureProvided !== $signature) {
            throw new Exception('Invalid signature');
        }

        return $payload;
    }
}