<?php

namespace P2c2p\P2c2pPayment\Controller\Token;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use P2c2p\P2c2pPayment\Model\TokenFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;

class Index extends \Magento\Framework\App\Action\Action
{
    protected $objTokenFactory;
    protected $objConfigSettings;

    public function __construct(Context $context, TokenFactory $objTokenFactory, ScopeConfigInterface $configSettings) {

        parent::__construct($context);
        $this->objTokenFactory = $objTokenFactory;
        $this->objConfigSettings = $configSettings->getValue('payment/p2c2ppayment', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    public function execute() {
        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        // echo print_r($this->objConfigSettings,1);

        if (!isset($this->objConfigSettings['storedCard'])) {
            return $resultJson->setData([]);
        }

        if (!isset($_POST['userId']) || empty($_POST['userId'])) {
            return $resultJson->setData([]);
        }

        $storedCards = [];
        $objTokenFactoryModel = $this->objTokenFactory->create();
        $tokenCollection = $objTokenFactoryModel->getCollection()
            ->addFieldToFilter('user_id', $_POST['userId']);
        // echo print_r($_GET['userId'],1);
        // echo print_r($tokenCollection->getData(),1); 

        foreach ($tokenCollection as $token) {
            $storedCards[] = [
                'stored_card_unique_id' => $token->getStoredCardUniqueId(),
                'masked_pan' => $token->getMaskedPan(),
            ];
        }
        $storedCards[] = [
            '' => '',
            'masked_pan' => '_new',
        ];

        return $resultJson->setData($storedCards);
    }
}