<?php

namespace P2c2p\P2c2pPayment\Controller\Payment;

use Exception;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Payment\Transaction;
use Magento\Sales\Model\Order\Invoice;

use P2c2p\P2c2pPayment\Controller\AbstractPosPaymentAction;

class Response extends AbstractPosPaymentAction
{
    public function execute()
    {
        // echo 'test!';
        // return;
        $this->_logger->debug('response!');
        // $this->_logger->debug('data:'.print_r($data,1));
        $request = $this->getRequest()->getPostValue();
        if (!isset($request["payload"]) || empty($request["payload"])) {
            $request = json_decode(file_get_contents('php://input'), true);
        }
        $this->_logger->debug('request:'.print_r($request,1));
        // $this->_logger->debug('_REQUEST:'.print_r($_REQUEST,1));
        $decodedPaymentToken = null;
        $order = null;

        // #1. Validation
        try {
            // 1.1 check for payload in request body
            if (!isset($request["payload"]) || empty($request["payload"])) {
                throw new Exception("No token payload in request");
            }

            // 1.2 check if payload token can be decoded
            $decodedPaymentToken = $this->decodePaymentToken($request["payload"]);
            $this->_logger->debug('decodedPaymentToken:'.print_r($decodedPaymentToken,1));

            // 1.3 retrieve order
            $orderId = $decodedPaymentToken["invoiceNo"];
            $order = $this->getOrder($orderId);

            if (!isset($order)) {
                throw new Exception("order does not exist");
            }
        } catch (Exception $e) {
            // return $this->_redirect("");
        }
        $this->_logger->debug('order:',['order'=>$order]);
        
        if (is_array($decodedPaymentToken) && isset($decodedPaymentToken['respCode'])) {
            // #2.process order
            $responseCode = $decodedPaymentToken["respCode"];
            $responseDescription = $decodedPaymentToken["respDesc"];
            $customerId = $order->getCustomerId();
            $isTransactionPending = $order->getStatus() === "Pending_2C2P";

            // 2.1 save request body
            if ($isTransactionPending) {
                $this->createMeta([
                    "user_id" => $customerId,
                    "p2c2p_id" => $orderId,
                    "order_id" => $orderId,
                    "version" => "",
                    "merchant_id" => $decodedPaymentToken["merchantID"],
                    "invoice_no" => $orderId,
                    "currency" => $decodedPaymentToken["currencyCode"],
                    "amount" => $decodedPaymentToken["amount"],
                    "transaction_ref" => $decodedPaymentToken["tranRef"] ?? "",
                    "approval_code" => $decodedPaymentToken["approvalCode"] ?? "",
                    "eci" => $decodedPaymentToken["eci"] ?? "",
                    "transaction_datetime" => $decodedPaymentToken["transactionDateTime"] ?? "",
                    "payment_channel" => "",
                    "payment_status" => "",
                    "channel_response_code" => $responseCode,
                    "channel_response_desc" => $responseDescription,
                    "masked_pan" => $decodedPaymentToken["accountNo"] ?? "",
                    "stored_card_unique_id" => $decodedPaymentToken["customerToken"] ?? "",
                    "backend_invoice" => "",
                    "paid_channel" => $decodedPaymentToken["channelCode"] ?? "",
                    "paid_agent" => $decodedPaymentToken["agentCode"] ?? "",
                    "recurring_unique_id" => "",
                    "user_defined_1" => $decodedPaymentToken["user_defined_1"] ?? "",
                    "user_defined_2" => $decodedPaymentToken["user_defined_2"] ?? "",
                    "user_defined_3" => $decodedPaymentToken["user_defined_3"] ?? "",
                    "user_defined_4" => $decodedPaymentToken["user_defined_4"] ?? "",
                    "user_defined_5" => $decodedPaymentToken["user_defined_5"] ?? "",
                    "browser_info" => "",
                    "ippPeriod" => $decodedPaymentToken["installmentPeriod"] ?? "",
                    "ippInterestType" => $decodedPaymentToken["interestType"] ?? "",
                    "ippInterestRate" => $decodedPaymentToken["interestRate"] ?? "",
                    "ippMerchantAbsorbRate" => $decodedPaymentToken["interestRate"] ?? ""
                ]);
                // $this->_logger->debug('createMeta!');
            }
            // $this->_logger->debug('responseCode:',['responseCode'=>$responseCode]);
            // transaction is successsful

            // if ($responseCode === "0000") {
            if (strcasecmp($responseCode, "0000") == 0) {
                $this->_logger->debug('successsful!');
                // check if transaction is using credit card and if the card is saved in db
                if (isset($decodedPaymentToken["customerToken"])) {
                    // $this->_logger->debug('decodedPaymentToken!');
                    // $this->_logger->debug('decodedPaymentToken:',['decodedPaymentToken'=>$decodedPaymentToken]);
                    // $this->_logger->debug('customerToken:',['customerToken'=>$decodedPaymentToken["customerToken"]]);
                    $accountNo = $decodedPaymentToken["accountNo"];
                    $customerToken = $decodedPaymentToken["customerToken"];
                    // $this->_logger->debug('customerToken:',['customerToken'=>$customerToken]);
                    $isTokenExists = $this->isTokenExists($customerId, $accountNo, $customerToken);
                    // $this->_logger->debug('isTokenExists:',['isTokenExists'=>$isTokenExists]);

                    if (!$isTokenExists) {
                        // $this->_logger->debug('customerToken 2:',['customerToken'=>$customerToken]);
                        if(isset($decodedPaymentToken["customerToken"]) && !empty($decodedPaymentToken["customerToken"])){
                            $arrayTokenData = [
                                "user_id" => $customerId,
                                "stored_card_unique_id" => $decodedPaymentToken["customerToken"],
                                "masked_pan" => $accountNo,
                                "created_time" => date("Y-m-d H:i:s")
                            ];
                            // $this->_logger->debug('arrayTokenData:',['arrayTokenData'=>$arrayTokenData]);
                            $this->createToken($arrayTokenData);
                        }
                    }
                }

                $settlementType = $this->_moduleConfigSettings['payment_action'];
                // $this->_logger->debug('settlementType:',['settlementType'=>$settlementType]);

                // update payment details
                // $this->setPaymentAdditionalInformation($order, $decodedPaymentToken, $settlementType);
                // $this->_logger->debug('setPaymentAdditionalInformation!');
                $transaction_ref = $decodedPaymentToken["tranRef"];
                $payment = $order->getPayment();
                $payment->setLastTransId($transaction_ref);
                $payment->setTransactionId($transaction_ref);
                $payment->setIsTransactionClosed(false);
                $payment->setAdditionalInformation( 
                    [\Magento\Sales\Model\Order\Payment\Transaction::RAW_DETAILS => (array)$payment->getAdditionalInformation()]
                );
                $trans = $this->_objectManager->create('Magento\Sales\Model\Order\Payment\Transaction\BuilderInterface');
        
                // Retrieve the settlement type from configHelper
                //$settlementType = $configHelper['payment_action'];
        
                // Determine the transaction type
                $transactionType = \Magento\Sales\Model\Order\Payment\Transaction::TYPE_AUTH;
                if ($settlementType == 'authorize_capture') {
                    $transactionType = \Magento\Sales\Model\Order\Payment\Transaction::TYPE_CAPTURE;
                }
        
                $transaction = $trans->setPayment($payment)
                    ->setOrder($order)
                    ->setTransactionId($transaction_ref)
                    ->setAdditionalInformation(
                        [\Magento\Sales\Model\Order\Payment\Transaction::RAW_DETAILS => (array)$payment->getAdditionalInformation()]
                    )
                    ->setFailSafe(true)
                    // Build method creates the transaction and returns the object
                    ->build($transactionType);
                $payment->setParentTransactionId(null);

                $this->_logger->debug('prepareInvoice!');
                $this->prepareInvoice($order, $settlementType);

                // update to processing if the transaction is pending
                if ($isTransactionPending) {
                    $this->_logger->debug('update to processing if the transaction is pending!');
                    if ($settlementType == 'authorize_capture') {
                        foreach ($order->getInvoiceCollection() as $invoice) {
                            if ($invoice->getState() == \Magento\Sales\Model\Order\Invoice::STATE_OPEN) {
                                $invoice->capture()->save();
                            }
                        }
                    }

                    $order->setState(Order::STATE_PROCESSING);
                    $order->setStatus(Order::STATE_PROCESSING);
                    $order->addStatusHistoryComment($responseDescription);
                    $order->save();
                }

                if ($order->getState() === Order::STATE_COMPLETE && $settlementType !== "authorize_capture") {
                    foreach ($order->getInvoiceCollection() as $invoice) {
                        if ($invoice->getState() === Invoice::STATE_OPEN) {
                            // $invoice->capture()->pay()->save();
                        }
                    }
                }
                $this->_logger->debug('order:',['order'=>$order]);

            } elseif (strcasecmp($responseCode, "0001") == 0) {
                // transaction is pending
                $order->addStatusHistoryComment($responseDescription);
                $order->save();
            // transaction is failed
            } else{
                //if ($responseCode !== "0000" || $responseCode !== "0003") {
                $order->setState(Order::STATE_CANCELED);
                $order->setStatus(Order::STATE_CANCELED);
                $order->addStatusHistoryComment($responseDescription);
                $order->save();

                // restore qoute
                $this->restoreQuote();
                // redirect to checkout cart page
                return $this->_redirect("checkout/cart", []);
            }

            // redirect to success page
            return $this->_forward("Success", "Payment", "p2c2p", $decodedPaymentToken);
        }else{
            return $this->_redirect("");
        }
    }
}
