<?php

namespace P2c2p\P2c2pPayment\Controller\Payment;

use Exception;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Invoice;

use P2c2p\P2c2pPayment\Controller\AbstractPosPaymentAction;

class Response extends AbstractPosPaymentAction
{
    public function execute()
    {
        echo 'test!';
        return;
        $request = $this->getRequest()->getPostValue();

        $decodedPaymentToken = null;
        $order = null;

        // #1. Validation
        try {
            // 1.1 check for payload in request body
            if (!isset($request["payload"]) || empty($request["payload"])) {
                throw new Exception("No token payload in request");
            }

            // 1.2 check if payload token can be decoded
            $decodedPaymentToken = $this->decodePaymentToken($request["payload"]);

            // 1.3 retrieve order
            $orderId = $decodedPaymentToken["invoiceNo"];
            $order = $this->getOrder($orderId);
            if (!isset($order)) {
                throw new Exception("order does not exist");
            }
        } catch (Exception $e) {
            return $this->_redirect("");
        }
        
        // #2.process order
        $responseCode = $decodedPaymentToken["respCode"];
        $responseDescription = $decodedPaymentToken["respDesc"];
        $customerId = $order->getCustomerId();
        $isTransactionPending = $order->getStatus() === "Pending_2C2P";

        // 2.1 save request body
        if ($isTransactionPending) {
            $this->createMeta([
                "user_id" => $customerId,
                "p2c2p_id" => $orderId,
                "order_id" => $orderId,
                "version" => "",
                "merchant_id" => $decodedPaymentToken["merchantID"],
                "invoice_no" => $orderId,
                "currency" => $decodedPaymentToken["currencyCode"],
                "amount" => $decodedPaymentToken["amount"],
                "transaction_ref" => $decodedPaymentToken["tranRef"] ?? "",
                "approval_code" => $decodedPaymentToken["approvalCode"] ?? "",
                "eci" => $decodedPaymentToken["eci"] ?? "",
                "transaction_datetime" => $decodedPaymentToken["transactionDateTime"] ?? "",
                "payment_channel" => "",
                "payment_status" => "",
                "channel_response_code" => $responseCode,
                "channel_response_desc" => $responseDescription,
                "masked_pan" => $decodedPaymentToken["accountNo"] ?? "",
                "stored_card_unique_id" => $decodedPaymentToken["customerToken"] ?? "",
                "backend_invoice" => "",
                "paid_channel" => $decodedPaymentToken["channelCode"] ?? "",
                "paid_agent" => $decodedPaymentToken["agentCode"] ?? "",
                "recurring_unique_id" => "",
                "user_defined_1" => $decodedPaymentToken["user_defined_1"] ?? "",
                "user_defined_2" => $decodedPaymentToken["user_defined_2"] ?? "",
                "user_defined_3" => $decodedPaymentToken["user_defined_3"] ?? "",
                "user_defined_4" => $decodedPaymentToken["user_defined_4"] ?? "",
                "user_defined_5" => $decodedPaymentToken["user_defined_5"] ?? "",
                "browser_info" => "",
                "ippPeriod" => $decodedPaymentToken["installmentPeriod"] ?? "",
                "ippInterestType" => $decodedPaymentToken["interestType"] ?? "",
                "ippInterestRate" => $decodedPaymentToken["interestRate"] ?? "",
                "ippMerchantAbsorbRate" => $decodedPaymentToken["interestRate"] ?? ""
            ]);
        }

        // transaction is failed
        if ($responseCode !== "0000" || $responseCode !== "0001") {
            $order->setState(Order::STATE_CANCELED);
            $order->setStatus(Order::STATE_CANCELED);
            $order->addStatusHistoryComment($responseDescription);
            $order->save();

            // restore qoute
            $this->restoreQuote();

            // redirect to checkout cart page
            return $this->_redirect("checkout/cart", []);
        }

        // transaction is successsful
        if ($responseCode === "0000") {
            // check if transaction is using credit card and if the card is saved in db
            if (isset($decodedPaymentToken["customerToken"])) {
                $accountNo = $decodedPaymentToken["accountNo"];
                $customerToken = $decodedPaymentToken["customerToken"];
                $isTokenExists = $this->isTokenExists($customerId, $accountNo, $customerToken);

                if (!$isTokenExists) {
                    if(isset($customerToken) && !empty($customerToken)){
                        $this->createToken([
                            "user_id" => $customerId,
                            "stored_card_uniqe_id" => $customerToken,
                            "masked_pan" => $accountNo,
                            "created_time" => date("Y-m-d H:i:s")
                        ]);
                    }
                }
            }

            // update to processing if the transaction is pending
            if ($isTransactionPending) {
                $order->setState(Order::STATE_PROCESSING);
                $order->setStatus(Order::STATE_PROCESSING);
                $order->addStatusHistoryComment($responseDescription);
                $order->save();
            }

            $settlementType = $this->_moduleConfigSettings['payment_action'];

            $this->prepareInvoice($order, $settlementType);

            if ($order->getState() === Order::STATE_COMPLETE && $settlementType !== "authorize_capture") {
                foreach ($order->getInvoiceCollection() as $invoice) {
                    if ($invoice->getState() === Invoice::STATE_OPEN) {
                        $invoice->capture()->pay()->save();
                    }
                }
            }
        }

        // transaction is pending
        if ($responseCode === "0001") {
            $order->addStatusHistoryComment($responseDescription);
            $order->save();
        }

        // redirect to success page
        return $this->_forward("Success", "Payment", "p2c2p", $decodedPaymentToken);
    }
}
