<?php

/*
 * Created by 2C2P
 * Date 20 June 2017
 * Payment Request Controller is responsible for send request to 2c2p payment getaway.
 */

namespace P2c2p\P2c2pPayment\Controller\Payment;

use Exception;

use P2c2p\P2c2pPayment\Controller\AbstractPrePaymentAction;

use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Message\ManagerInterface;

class Request extends AbstractPrePaymentAction
{
    public function execute()
    {
        try {
            $orderId = $this->getLastOrderId();
            if (empty($orderId)) {
                // echo "1";
                // exit();
                // die("Aunthentication Error: Order is empty.");
                return $this->redirectToCartWithError('You are having an order issue. Please try again.');
            }

            $order = $this->getOrder($orderId);
            if (!isset($order)) {
                // echo "2";
                // exit();
                // return $this->_redirect("");
                return $this->redirectToCartWithError('You are having an order issue. Please try again.');
            }

            $token = $this->generatePaymentPayloadToken($order);
            // echo '<pre>token: '.print_r($token,1).'</pre>';
            $response = $this->_p2c2pService->paymentToken($token);
            // echo '<pre>'.print_r($response,1).'</pre>';
            if (
                $response["status"] !== 200 ||
                empty($response["data"]) ||
                !isset($response["data"]["payload"])
            ) {
                // echo "2";
                // exit();
                // return $this->_redirect("");
                return $this->redirectToCartWithError('Payment gateway error. Please choose another method.');
            }

            $paymentToken = $response["data"]["payload"];
            $paymentGetwayRedirectUrl = $this->getPaymentGetwayRedirectUrl(
                $paymentToken
            );
            if (empty($paymentGetwayRedirectUrl)) {
                // echo "2";
                // exit();
                // return $this->_redirect("");
                return $this->redirectToCartWithError('Payment gateway error. Please choose another method.');
            }

            $resultRedirect = $this->_redirectFactory->setUrl(
                $paymentGetwayRedirectUrl
            );
            return $resultRedirect;
        } catch (Exception $e) {
        } finally {
            // TODO: this should be moved to catch block
            $this->_redirect("checkout/cart", []);
        }
    }
}
