<?php

namespace P2c2p\P2c2pPayment\Controller\Payment;

use Exception;
use Magento\Sales\Model\Order;

use P2c2p\P2c2pPayment\Controller\AbstractPaymentAction;

class FrontEndResponse extends AbstractPaymentAction
{
    public function execute()
    {
        try {
            $request = $this->getRequest()->getPostValue();
            if (!isset($request["paymentResponse"]) || empty($request["paymentResponse"])) {
                throw new Exception("paymentResponse is empty");
            }

            $decodedPaymentToken = $this->decodeFEPaymentToken($request["paymentResponse"]);
            if (!isset($decodedPaymentToken["respCode"])) {
                throw new Exception("no response code");
            }

            $responseCode = $decodedPaymentToken["respCode"];

            // responseCode ref - https://developer.2c2p.com/docs/response-code-payment-flow
            // check if transaction is failed
            if ($responseCode !== "2000" || empty($decodedPaymentToken["channelCode"])) {
                // transaction was cancelled
                if (empty($decodedPaymentToken["channelCode"])) {
                    $orderId = $decodedPaymentToken["invoiceNo"];
                    $order = $this->getOrder($orderId);
                    if (
                        isset($order) &&
                        $order->getStatus() !== Order::STATE_CANCELED
                    ) {
                        $order->setState(Order::STATE_CANCELED);
                        $order->setStatus(Order::STATE_CANCELED);
                        $order->addStatusHistoryComment(
                            $decodedPaymentToken["respDesc"]
                        );
                        $order->save();
                    }
                }

                return $this->_forward(
                    "Failed",
                    "Payment",
                    "p2c2p",
                    $decodedPaymentToken
                );
            }

            return $this->_forward("Success", "Payment", "p2c2p", $decodedPaymentToken);
        } catch (Exception $e) {
            return $this->_forward(
                "Failed",
                "Payment",
                "p2c2p",
                $this->getRequest()->getPostValue()
            );
        }
    }
}
