<?php

namespace P2c2p\P2c2pPayment\Controller;

use Magento\Catalog\Model\Session as CatalogSession;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Sales\Model\OrderFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Sales\Model\Service\InvoiceService;
use Psr\Log\LoggerInterface as PsrLoggerInterface;

use P2c2p\P2c2pPayment\Helper\JWT;
use P2c2p\P2c2pPayment\Helper\P2c2pService;
use P2c2p\P2c2pPayment\Model\TokenFactory;

abstract class AbstractPrePaymentAction extends AbstractPaymentAction
{
    protected $_catalogSession;
    protected $_configSettings;
    protected $_customerSession;
    protected $_p2c2pService;
    protected $_redirectFactory;
    protected $_storeManager;
    protected $_tokenFactory;

    public function __construct(
        Context $context,
        CatalogSession $catalogSession,
        CheckoutSession $checkoutSession,
        ScopeConfigInterface $configSettings,
        CustomerSession $customerSession,
        JWT $jwtHelper,
        PsrLoggerInterface $logger,
        OrderFactory $orderFactory,
        P2c2pService $p2c2pService,
        Redirect $redirectFactory,
        StoreManagerInterface $storeManager,
        TokenFactory $tokenFactory
    ) {
        parent::__construct(
            $context,
            $checkoutSession,
            $configSettings,
            $jwtHelper,
            $logger,
            $orderFactory
        );

        $this->_catalogSession = $catalogSession;
        $this->_customerSession = $customerSession;
        $this->_p2c2pService = $p2c2pService;
        $this->_redirectFactory = $redirectFactory;
        $this->_storeManager = $storeManager;
        $this->_tokenFactory = $tokenFactory;
    }

    protected function getCustomerEmail($order)
    {
        $customer = $this->_customerSession->getCustomer();

        // return email from customer session
        if ($customer->isLoggedIn()) {
            return $customer->getEmail();
        }

        $billingAddress = $order->getBillingAddress();

        // return email from billing address
        return $billingAddress->getEmail();
    }

    protected function getOrderDescription($order)
    {
        $orderItems = $order->getAllItems();
        $orderItemsCount = count($orderItems);
        $description = "";

        for ($i = 0; $i < $orderItemsCount; $i++) {
            $description .= $orderItems[$i]->getName();

            if ($i < $orderItemsCount - 1) {
                $description .= ", ";
            } elseif ($i == $orderItemsCount - 1) {
                $description .= ".";
            }
        }

        return substr($description, 0, 240);
    }

    protected function getStoredCardToken($tokenId)
    {
        return $this->_tokenFactory->create()
            ->load($tokenId);
    }

    protected function generatePaymentPayloadToken($order)
    {
        $merchantId = $this->_moduleConfigSettings["merchantId"];
        $locale = $this->_moduleConfigSettings["toc2p_lang"] ?? "en";

        $store = $this->_storeManager->getStore();
        $currency = $store->getBaseCurrency()->getCode();
        $baseUrl = $store->getBaseUrl();

        // $storedCardToken = empty($this->_catalogSession->getTokenValue()) ? 
        //     null : $this->getStoredCardToken($this->_catalogSession->getTokenValue());
        // $uniqueCardId = empty($storedCardToken) ? null : $storedCardToken->get("stored_card_unique_id");

        // $objCatalogSessionHelper = $this->getCatalogSession();
        $tokenId = $this->_catalogSession->getTokenValue(); 
		$strTokenKey = $tokenId;
        // $this->_logger->debug('strTokenKey:',['strTokenKey'=>$strTokenKey]);

        $payload = [
            "merchantId" => $merchantId,
            "invoiceNo" => $order->getIncrementId(),
            "currencyCode" => $currency, 
            "amount" => round($order->getBaseGrandTotal(), 2),
            "description" => $this->getOrderDescription($order),
            "lang" => $locale,
            "frontendReturnUrl" => $baseUrl . "p2c2p/payment/frontendresponse",
            "backendReturnUrl" => $baseUrl . "p2c2p/payment/response"
        ];
        if($order->getCustomerId()){
            $payload = [
                "merchantId" => $merchantId,
                "invoiceNo" => $order->getIncrementId(),
                "currencyCode" => $currency, 
                "amount" => round($order->getBaseGrandTotal(), 2),
                "description" => $this->getOrderDescription($order),
                "lang" => $locale,
                "frontendReturnUrl" => $baseUrl . "p2c2p/payment/frontendresponse",
                "backendReturnUrl" => $baseUrl . "p2c2p/payment/response",
                "tokenize" => true,
                "customerToken" => [$strTokenKey]
            ];
        }

        return $this->createPaymentToken($payload);
    }

    protected function getPaymentGetwayRedirectUrl($token)
    {
        $decodedPaymentToken = $this->decodePaymentToken($token);

        if (
            !isset($decodedPaymentToken["respCode"]) ||
            $decodedPaymentToken["respCode"] !== "0000"
        ) {
            return null;
        }

        return $decodedPaymentToken["webPaymentUrl"];
    }

    protected function getCatalogSession()
    {
        return $this->objCatalogSession;
    }

    protected function redirectToCartWithError($errorMessage = 'An error occurred. Please try again.'){
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $messageManager = $objectManager->get(\Magento\Framework\Message\ManagerInterface::class);
        $messageManager->addErrorMessage(__($errorMessage));

        $resultRedirectFactory = $objectManager->get(\Magento\Framework\Controller\Result\RedirectFactory::class);
        $resultRedirect = $resultRedirectFactory->create();
        $resultRedirect->setPath('checkout/cart');

        return $resultRedirect;
    }
}