<?php

namespace P2c2p\P2c2pPayment\Controller;

use Magento\Catalog\Model\Session as CatalogSession;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Sales\Model\OrderFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;
use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order\Payment\Transaction;
use Magento\Sales\Model\Order\Payment\Transaction\BuilderInterface;
use Magento\Sales\Model\Service\InvoiceService;
use Psr\Log\LoggerInterface as PsrLoggerInterface;

use P2c2p\P2c2pPayment\Helper\JWT;
use P2c2p\P2c2pPayment\Helper\P2c2pService;
use P2c2p\P2c2pPayment\Model\MetaFactory;
use P2c2p\P2c2pPayment\Model\TokenFactory;

abstract class AbstractPosPaymentAction extends AbstractPaymentAction
{
    protected $_catalogSession;
    protected $_configSettings;
    protected $_customerSession;
    protected $_metaFactory;
    // protected $_objectManager;
    protected $_p2c2pService;
    protected $_redirectFactory;
    protected $_storeManager;
    protected $_tokenFactory;

    protected $invoiceService;

    public function __construct(
        Context $context,
        CatalogSession $catalogSession,
        CheckoutSession $checkoutSession,
        ScopeConfigInterface $configSettings,
        InvoiceService $invoiceService,
        CustomerSession $customerSession,
        JWT $jwtHelper,
        PsrLoggerInterface $logger,
        MetaFactory $metaFactory,
        // ObjectManager $objectManager,
        OrderFactory $orderFactory,
        P2c2pService $p2c2pService,
        Redirect $redirectFactory,
        StoreManagerInterface $storeManager,
        TokenFactory $tokenFactory
    ) {
        parent::__construct(
            $context,
            $checkoutSession,
            $configSettings,
            $jwtHelper,
            $logger,
            $orderFactory
        );

        $this->_catalogSession = $catalogSession;
        $this->_customerSession = $customerSession;
        $this->invoiceService = $invoiceService;
        $this->_metaFactory = $metaFactory;
        // $this->_objectManager = $objectManager;
        $this->_p2c2pService = $p2c2pService;
        $this->_redirectFactory = $redirectFactory;
        $this->_storeManager = $storeManager;
        $this->_tokenFactory = $tokenFactory;
    }

    protected function createToken($data)
    {
        return $this->_tokenFactory->create()->setData($data)->save();
    }

    protected function createMeta($data)
    {
        return $this->_metaFactory->create()->setData($data)->save();
    }

    protected function getToken($tokenId)
    {
        $token = $this->_tokenFactory->create()->load($tokenId);

        if (!isset($token) || empty($token)) {
            return null;
        }

        return $token;
    }

    protected function getTokensByUserId($userId)
    {
        return $this->_tokenFactory
            ->create()
            ->getCollection()
            ->addFieldToFilter("user_id", $userId);
    }

    protected function isTokenExists($userId, $accountNo, $customerToken)
    {
        $tokens = $this->getTokensByUserId($userId);
        $isTokenExists = false;
        foreach ($tokens as $key => $value) {
            $maskedPan = $value->getData("masked_pan");
            $storedCardUniqueId = $value->getData("stored_card_unique_id");

            if (
                strcasecmp($maskedPan, $accountNo) == 0 &&
                strcasecmp($storedCardUniqueId, $customerToken)
            ) {
                $isTokenExists = true;
                break;
            }
        }

        return $isTokenExists;
    }

    protected function prepareInvoice($order, $settlementType = "authorize_capture")
    {
        if ($order->canInvoice()) {
            // Create invoice for this order
            $invoice = $this->_objectManager->create('Magento\Sales\Model\Service\InvoiceService')->prepareInvoice($order);
        
            // Make sure there is a qty on the invoice
            if (!$invoice || !$invoice->getTotalQty()) {
                throw new \Magento\Framework\Exception\LocalizedException(
                            __('You can\'t create an invoice without products.')
                        );
            }
        
            // Register as invoice item
            if ($settlementType == 'authorize_capture') {
                $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::CAPTURE_ONLINE);
            }
            $invoice->register();
            $invoice->getOrder()->setIsInProcess(true);
        
            // Save the invoice to the order
            $transaction = $this->_objectManager->create('Magento\Framework\DB\Transaction')
                ->addObject($invoice)
                ->addObject($invoice->getOrder());
            $transaction->save();

            $orderSender = $this->_objectManager->get(
                "Magento\Sales\Model\Order\Email\Sender\OrderSender"
            );
            $orderSender->send($order);
    
            // Set invoice state based on settlement type
            if ($settlementType != 'authorize_capture') {
                $invoice->setState(\Magento\Sales\Model\Order\Invoice::STATE_OPEN)->save();
            }
        }
        // if ($order->canInvoice()) {
        //     // $this->_logger->debug('prepareInvoice!');
        //     // $this->_logger->debug('order:',['order'=>$order->getData()]);
        //     // $invoice = $this->invoiceService->prepareInvoice($order, []);
        //     // $invoice = $this->invoiceService->prepareInvoice($order);
        //     $invoice = $this->_objectManager->create('Magento\Sales\Model\Service\InvoiceService')->prepareInvoice($order);
        //     // $this->_logger->debug('invoice:',['invoice'=>$invoice->getData()]);
        //     if (!$invoice || empty($invoice->getTotalQty())) {
        //         $this->_logger->debug('!invoice:');
        //         return;
        //     }
        //     // $this->_logger->debug('invoice:');

        //     if ($settlementType === "authorize") {
        //         $this->_logger->debug('authorize online!',['invoice'=>Invoice::CAPTURE_ONLINE]);
        //         $invoice->setRequestedCaptureCase(Invoice::CAPTURE_ONLINE);
        //     }
        //     $invoice->addComment('Invoice genrated automatically');
        //     //$this->invoiceService->setCapture($invoice->getEntityId());
        //     $this->_logger->debug('invoice register!');
        //     $this->_logger->debug('invoice:',['invoice'=>$invoice->getData()]);
        //     $this->_logger->debug('settlementType:',['settlementType'=>$settlementType]);
        //     $invoice->register();
        //     $this->_logger->debug('invoice getOrder!',['order'=>$invoice->getData()]);
        //     $invoice->getOrder()->setIsInProcess(true);
        //     $this->_logger->debug('invoice getOrder!');

        //     $objectManager = ObjectManager::getInstance();
        //     $transactionSave = $objectManager
        //         ->create(Transaction::class)
        //         ->addObject($invoice)
        //         ->addObject($invoice->getOrder());
        //     $transactionSave->save();
        //     $this->_logger->debug('transactionSave:',['transactionSave'=>$transactionSave->getData()]);

        //     $orderSender = $objectManager->get(OrderSender::class);
        //     $orderSender->send($order);

        //     if ($settlementType === "authorize") {
        //         $invoice->setState(Invoice::STATE_OPEN)->save();
        //     } else {
        //         // $invoice->pay();
        //     }
        //     $this->_logger->debug('invoice:',['invoice'=>$invoice->getData()]);
        // }
        else{
            $this->_logger->debug('cant create invoice!',['order'=>$order->getData()]);
        }
    }

    protected function restoreQuote()
    {
        return $this->_checkoutSession->restoreQuote();
    }

    protected function setPaymentAdditionalInformation($order, $decodedPaymentToken, $settlementType)
    {
        $transactionReference = $decodedPaymentToken["tranRef"];

        $payment = $order->getPayment();
        $payment->setLasttransId($transactionReference);
        $payment->setTransactionId($transactionReference);
        $payment->setIsTransactionClosed(false);
        $payment->setAdditionalinformation([
            Transaction::RAW_DETAILS => (array) $payment->getAdditionalinformation(),
        ]);

        $objectManager = ObjectManager::getInstance();
        $transactionFactory = $objectManager->create(BuilderInterface::class);
        $transactionType = $settlementType == "authorize_capture" ? Transaction::TYPE_CAPTURE : Transaction::TYPE_AUTH;
        $transaction = $transactionFactory->setPayment($payment)
            ->setOrder($order)
            ->setTransactionId($transactionReference)
            ->setAdditionalInformation([
                Transaction::RAW_DETAILS => (array) $payment->getAdditionalInformation(),
            ])
            ->setFailSafe(true)
            ->build($transactionType);
        
        $payment->setTransactionId(null);
    }
}
