<?php

namespace P2c2p\P2c2pPayment\Controller;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Sales\Model\OrderFactory;
use Psr\Log\LoggerInterface as PsrLoggerInterface;

use P2c2p\P2c2pPayment\Helper\JWT;

abstract class AbstractPaymentAction extends AbstractAction
{
    protected $_checkoutSession;
    protected $_orderFactory;

    public function __construct(
        Context $context,
        CheckoutSession $checkoutSession,
        ScopeConfigInterface $configSettings,
        JWT $jwtHelper,
        PsrLoggerInterface $logger,
        OrderFactory $orderFactory
    ) {
        parent::__construct($context, $jwtHelper, $logger, $configSettings);

        $this->_checkoutSession = $checkoutSession;
        $this->_orderFactory = $orderFactory;
    }

    protected function getLastOrderId()
    {
        return $this->_checkoutSession->getLastRealOrderId();
    }

    protected function getOrder($orderId)
    {
        $order = $this->_orderFactory->create()
            ->loadByIncrementId($orderId);

        if (!$order->getId()) {
            return null;
        }

        return $order;
    }
}
