<?php

/*
 * Created by 2C2P
 * Date 20 June 2017
 * AbstractAction class is base class for P2c2p payment getaway.
 */

namespace P2c2p\P2c2pPayment\Controller;

use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Store\Model\ScopeInterface;
use Psr\Log\LoggerInterface as PsrLoggerInterface;

use P2c2p\P2c2pPayment\Helper\JWT;

abstract class AbstractAction extends Action implements CsrfAwareActionInterface
{
    protected $_configSettings;
    protected $_context;
    protected $_logger;
    protected $_moduleConfigSettings;

    private $jwtHelper;

    public function __construct(
        Context $context,
        JWT $jwtHelper,
        PsrLoggerInterface $logger,
        ScopeConfigInterface $configSettings
    ) {
        parent::__construct($context);

        $this->_configSettings = $configSettings;
        $this->_context = $context;
        $this->_logger = $logger;
        $this->_moduleConfigSettings = $configSettings->getValue(
            "payment/p2c2ppayment",
            ScopeInterface::SCOPE_STORE
        );

        $this->jwtHelper = $jwtHelper;
    }

    // Get Magneto ObjectManager object.
    protected function getObjectManager()
    {
        return $this->_objectManager;
    }

    protected function createPaymentToken($data)
    {
        $secretKey = $this->_moduleConfigSettings["secretKey"];

        return $this->jwtHelper->createJwt($secretKey, $data);
    }

    protected function decodePaymentToken($token)
    {
        $secretKey = $this->_moduleConfigSettings["secretKey"];

        return $this->jwtHelper->decodeJwt($secretKey, $token);
    }

    protected function decodeFEPaymentToken($token)
    {
        return $this->jwtHelper->decodeBase64Json($token);
    }

    public function createCsrfValidationException(
        RequestInterface $request
    ): ?InvalidRequestException {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }
}
